package ru.yandex.partner.coreexperiment.entity.user.builder;

import java.time.LocalDateTime;

import org.springframework.stereotype.Component;

import ru.yandex.partner.coreexperiment.BuilderInterface;
import ru.yandex.partner.coreexperiment.entity.field.CreateDate;
import ru.yandex.partner.coreexperiment.entity.field.Id;
import ru.yandex.partner.coreexperiment.entity.field.Multistate;
import ru.yandex.partner.coreexperiment.entity.user.field.BusinessUnit;
import ru.yandex.partner.coreexperiment.entity.user.field.ClientId;
import ru.yandex.partner.coreexperiment.entity.user.field.Email;
import ru.yandex.partner.coreexperiment.entity.user.field.HasApproved;
import ru.yandex.partner.coreexperiment.entity.user.field.HasCommonOffer;
import ru.yandex.partner.coreexperiment.entity.user.field.HasMobileMediation;
import ru.yandex.partner.coreexperiment.entity.user.field.HasRsya;
import ru.yandex.partner.coreexperiment.entity.user.field.HasTutbyAgreement;
import ru.yandex.partner.coreexperiment.entity.user.field.IsMobileMediation;
import ru.yandex.partner.coreexperiment.entity.user.field.Lastname;
import ru.yandex.partner.coreexperiment.entity.user.field.Login;
import ru.yandex.partner.coreexperiment.entity.user.field.Midname;
import ru.yandex.partner.coreexperiment.entity.user.field.Name;
import ru.yandex.partner.coreexperiment.entity.user.field.Newsletter;
import ru.yandex.partner.coreexperiment.entity.user.field.Phone;
import ru.yandex.partner.coreexperiment.entity.user.model.User;

@Component
public class UserBuilder implements BuilderInterface<User> {
    private Long id;

    private String login;

    private String lastname;

    private String name;

    private String midname;

    private String email;

    private Long multistate;

    private Long clientId;

    private String phone;

    private Boolean newsletter;

    private Boolean businessUnit;

    private LocalDateTime createDate;

    private Boolean isMobileMediation;

    private Boolean hasRsya;

    private Boolean hasMobileMediation;

    private Boolean hasApproved;

    private Boolean hasTutbyAgreement;

    private Boolean hasCommonOffer;

    public User build() {
        Id idObj = new Id(id);

        Login loginObj = new Login(login);

        Lastname lastnameObj = new Lastname(lastname);

        Name nameObj = new Name(name);

        Midname midnameObj = new Midname(midname);

        Email emailObj = new Email(email);

        Multistate multistateObj = new Multistate(multistate);

        ClientId clientIdObj = new ClientId(clientId);

        Phone phoneObj = new Phone(phone);

        Newsletter newsletterObj = new Newsletter(newsletter);

        BusinessUnit businessUnitObj = new BusinessUnit(businessUnit);

        CreateDate createDateObj = new CreateDate(createDate);

        IsMobileMediation isMobileMediationObj = new IsMobileMediation(isMobileMediation);

        HasRsya hasRsyaObj = new HasRsya(hasRsya);

        HasMobileMediation hasMobileMediationObj = new HasMobileMediation(hasMobileMediation);

        HasApproved hasApprovedObj = new HasApproved(hasApproved);

        HasTutbyAgreement hasTutbyAgreementObj = new HasTutbyAgreement(hasTutbyAgreement);

        HasCommonOffer hasCommonOfferObj = new HasCommonOffer(hasCommonOffer);

        return new User(
                idObj,
                loginObj,
                lastnameObj,
                nameObj,
                midnameObj,
                emailObj,
                multistateObj,
                clientIdObj,
                phoneObj,
                newsletterObj,
                businessUnitObj,
                createDateObj,
                isMobileMediationObj,
                hasRsyaObj,
                hasMobileMediationObj,
                hasApprovedObj,
                hasTutbyAgreementObj,
                hasCommonOfferObj
        );
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMidname(String midname) {
        this.midname = midname;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setMultistate(Long multistate) {
        this.multistate = multistate;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setNewsletter(Boolean newsletter) {
        this.newsletter = newsletter;
    }

    public void setBusinessUnit(Boolean businessUnit) {
        this.businessUnit = businessUnit;
    }

    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }

    public void setIsMobileMediation(Boolean isMobileMediation) {
        this.isMobileMediation = isMobileMediation;
    }

    public void setHasRsya(Boolean hasRsya) {
        this.hasRsya = hasRsya;
    }

    public void setHasMobileMediation(Boolean hasMobileMediation) {
        this.hasMobileMediation = hasMobileMediation;
    }

    public void setHasApproved(Boolean hasApproved) {
        this.hasApproved = hasApproved;
    }

    public void setHasTutbyAgreement(Boolean hasTutbyAgreement) {
        this.hasTutbyAgreement = hasTutbyAgreement;
    }

    public void setHasCommonOffer(Boolean hasCommonOffer) {
        this.hasCommonOffer = hasCommonOffer;
    }
}
