package ru.yandex.partner.coreexperiment.entity.user.convertor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.stereotype.Component;

import ru.yandex.partner.coreexperiment.ConverterInterface;
import ru.yandex.partner.coreexperiment.entity.user.model.User;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.libs.exceptions.JsonProcessException;

import static ru.yandex.partner.libs.utils.TypesConvertor.convertBooleanToByte;
import static ru.yandex.partner.libs.utils.TypesConvertor.convertBooleanToLong;

@Component
public class UserToUsersRecordConverter implements ConverterInterface<User, UsersRecord> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public UsersRecord convert(User user) {
        UsersRecord usersRecord = new UsersRecord();

        usersRecord.setId(user.getId().getValue());

        usersRecord.setLogin(user.getLogin().getValue());

        usersRecord.setLastname(user.getLastname().getValue());

        usersRecord.setName(user.getName().getValue());

        usersRecord.setMidname(user.getMidname().getValue());

        usersRecord.setEmail(user.getEmail().getValue());

        usersRecord.setMultistate(user.getMultistate().getValue());

        usersRecord.setClientId(user.getClientId().getValue());

        usersRecord.setPhone(user.getPhone().getValue());

        usersRecord.setNewsletter(convertBooleanToLong(user.getNewsletter().getValue()));

        usersRecord.setBusinessUnit(convertBooleanToLong(user.getBusinessUnit().getValue()));

        usersRecord.setCreateDate(user.getCreateDate().getValue());

        usersRecord.setIsMobileMediation(convertBooleanToLong(user.getIsMobileMediation().getValue()));

        UserOpts opts = new UserOpts();
        opts.setHasRsya(convertBooleanToByte(user.getHasRsya().getValue()));
        opts.setHasMobileMediation(convertBooleanToByte(user.getHasMobileMediation().getValue()));
        opts.setHasApproved(convertBooleanToByte(user.getHasApproved().getValue()));
        opts.setHasTutbyAgreement(convertBooleanToByte(user.getHasTutbyAgreement().getValue()));
        opts.setHasCommonOffer(convertBooleanToByte(user.getHasCommonOffer().getValue()));

        String jsonOpts = null;

        try {
            jsonOpts = objectMapper.writeValueAsString(opts);
        } catch (JsonProcessingException e) {
            throw new JsonProcessException("Json processing error on UserOpts", e);
        }

        usersRecord.setOpts(jsonOpts);

        return usersRecord;
    }
}
