package ru.yandex.partner.coreexperiment.entity.user.convertor;

import java.io.IOException;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.stereotype.Component;

import ru.yandex.partner.coreexperiment.ConverterInterface;
import ru.yandex.partner.coreexperiment.entity.user.builder.UserBuilder;
import ru.yandex.partner.coreexperiment.entity.user.model.User;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.libs.exceptions.JsonParseException;

import static ru.yandex.partner.libs.utils.TypesConvertor.convertByteToBoolean;
import static ru.yandex.partner.libs.utils.TypesConvertor.convertLongToBoolean;

@Component
public class UsersRecordToUserConverter implements ConverterInterface<UsersRecord, User> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public User convert(UsersRecord usersRecord) {
        UserBuilder builder = new UserBuilder();

        builder.setId(usersRecord.getId());

        builder.setLogin(usersRecord.getLogin());

        builder.setLastname(usersRecord.getLastname());

        builder.setName(usersRecord.getName());

        builder.setMidname(usersRecord.getMidname());

        builder.setEmail(usersRecord.getEmail());

        builder.setMultistate(usersRecord.getMultistate());

        builder.setClientId(usersRecord.getClientId());

        builder.setPhone(usersRecord.getPhone());

        builder.setNewsletter(convertLongToBoolean(usersRecord.getNewsletter()));

        builder.setBusinessUnit(convertLongToBoolean(usersRecord.getBusinessUnit()));

        builder.setCreateDate(usersRecord.getCreateDate());

        builder.setIsMobileMediation(convertLongToBoolean(usersRecord.getIsMobileMediation()));

        UserOpts opts = null;

        try {
            opts = objectMapper.readValue(usersRecord.getOpts(), UserOpts.class);
        } catch (IOException e) {
            throw new JsonParseException("Json parse error on UserOpts", e);
        }

        builder.setHasRsya(opts != null ? convertByteToBoolean(opts.getHasApproved()) : null);
        builder.setHasMobileMediation(opts != null ? convertByteToBoolean(opts.getHasMobileMediation()) : null);
        builder.setHasApproved(opts != null ? convertByteToBoolean(opts.getHasApproved()) : null);
        builder.setHasTutbyAgreement(opts != null ? convertByteToBoolean(opts.getHasTutbyAgreement()) : null);
        builder.setHasCommonOffer(opts != null ? convertByteToBoolean(opts.getHasCommonOffer()) : null);

        return builder.build();
    }
}
