package ru.yandex.partner.coreexperiment.entity.user.field;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.partner.coreexperiment.ModelFieldInterface;

public class BusinessUnit implements ModelFieldInterface {
    private Boolean businessUnit;

    public BusinessUnit(Boolean businessUnit) {
        this.businessUnit = businessUnit;
    }

    public Boolean getBusinessUnit() {
        return businessUnit;
    }

    @JsonIgnore
    public Boolean getValue() {
        return this.getBusinessUnit();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BusinessUnit)) {
            return false;
        }
        BusinessUnit that = (BusinessUnit) o;
        return businessUnit.equals(that.businessUnit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(businessUnit);
    }
}
