package ru.yandex.partner.coreexperiment.entity.user.field;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.partner.coreexperiment.ModelFieldInterface;

public class HasApproved implements ModelFieldInterface {
    private Boolean hasApproved;

    public HasApproved(Boolean hasApproved) {
        this.hasApproved = hasApproved;
    }

    public Boolean getHasApproved() {
        return hasApproved;
    }

    @JsonIgnore
    public Boolean getValue() {
        return this.getHasApproved();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HasApproved)) {
            return false;
        }
        HasApproved that = (HasApproved) o;
        return hasApproved.equals(that.hasApproved);
    }

    @Override
    public int hashCode() {
        return Objects.hash(hasApproved);
    }
}
