package ru.yandex.partner.coreexperiment.entity.user.field;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.partner.coreexperiment.ModelFieldInterface;

public class HasCommonOffer implements ModelFieldInterface {
    private Boolean hasCommonOffer;

    public HasCommonOffer(Boolean hasCommonOffer) {
        this.hasCommonOffer = hasCommonOffer;
    }

    public Boolean getHasCommonOffer() {
        return hasCommonOffer;
    }

    @JsonIgnore
    public Boolean getValue() {
        return this.getHasCommonOffer();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HasCommonOffer)) {
            return false;
        }
        HasCommonOffer that = (HasCommonOffer) o;
        return hasCommonOffer.equals(that.hasCommonOffer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(hasCommonOffer);
    }
}
