package ru.yandex.partner.coreexperiment.entity.user.field;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.partner.coreexperiment.ModelFieldInterface;

public class Lastname implements ModelFieldInterface {
    private String lastname;

    public Lastname(String lastname) {
        this.lastname = lastname;
    }

    public String getLastname() {
        return lastname;
    }

    @JsonIgnore
    public String getValue() {
        return this.getLastname();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Lastname)) {
            return false;
        }
        Lastname lastname1 = (Lastname) o;
        return lastname.equals(lastname1.lastname);
    }

    @Override
    public int hashCode() {
        return Objects.hash(lastname);
    }
}
