package ru.yandex.partner.coreexperiment.entity.user.field;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.partner.coreexperiment.ModelFieldInterface;

public class Newsletter implements ModelFieldInterface {
    private Boolean newsletter;

    public Newsletter(Boolean newsletter) {
        this.newsletter = newsletter;
    }

    public Boolean getNewsletter() {
        return newsletter;
    }

    @JsonIgnore
    public Boolean getValue() {
        return this.getNewsletter();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Newsletter)) {
            return false;
        }
        Newsletter that = (Newsletter) o;
        return newsletter.equals(that.newsletter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(newsletter);
    }
}
