package ru.yandex.partner.coreexperiment.entity.user.field;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.partner.coreexperiment.ModelFieldInterface;

public class Phone implements ModelFieldInterface {
    private String phone;

    public Phone(String phone) {
        this.phone = phone;
    }

    public String getPhone() {
        return phone;
    }

    @JsonIgnore
    public String getValue() {
        return this.getPhone();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Phone)) {
            return false;
        }
        Phone phone1 = (Phone) o;
        return phone.equals(phone1.phone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(phone);
    }
}
