package ru.yandex.partner.coreexperiment.entity.user.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonUnwrapped;

import ru.yandex.partner.coreexperiment.ModelInterface;
import ru.yandex.partner.coreexperiment.entity.field.CreateDate;
import ru.yandex.partner.coreexperiment.entity.field.Id;
import ru.yandex.partner.coreexperiment.entity.field.Multistate;
import ru.yandex.partner.coreexperiment.entity.user.field.BusinessUnit;
import ru.yandex.partner.coreexperiment.entity.user.field.ClientId;
import ru.yandex.partner.coreexperiment.entity.user.field.Email;
import ru.yandex.partner.coreexperiment.entity.user.field.HasApproved;
import ru.yandex.partner.coreexperiment.entity.user.field.HasCommonOffer;
import ru.yandex.partner.coreexperiment.entity.user.field.HasMobileMediation;
import ru.yandex.partner.coreexperiment.entity.user.field.HasRsya;
import ru.yandex.partner.coreexperiment.entity.user.field.HasTutbyAgreement;
import ru.yandex.partner.coreexperiment.entity.user.field.IsMobileMediation;
import ru.yandex.partner.coreexperiment.entity.user.field.Lastname;
import ru.yandex.partner.coreexperiment.entity.user.field.Login;
import ru.yandex.partner.coreexperiment.entity.user.field.Midname;
import ru.yandex.partner.coreexperiment.entity.user.field.Name;
import ru.yandex.partner.coreexperiment.entity.user.field.Newsletter;
import ru.yandex.partner.coreexperiment.entity.user.field.Phone;

public class User implements ModelInterface {
    @JsonIgnore
    private Id id;

    @JsonUnwrapped
    private Login login;

    @JsonUnwrapped
    private Lastname lastname;

    @JsonUnwrapped
    private Name name;

    @JsonUnwrapped
    private Midname midname;

    @JsonUnwrapped
    private Email email;

    @JsonUnwrapped
    private Multistate multistate;

    @JsonUnwrapped
    private ClientId clientId;

    @JsonUnwrapped
    private Phone phone;

    @JsonUnwrapped
    private Newsletter newsletter;

    @JsonUnwrapped
    private BusinessUnit businessUnit;

    @JsonUnwrapped
    private CreateDate createDate;

    @JsonUnwrapped
    private IsMobileMediation isMobileMediation;

    @JsonUnwrapped
    private HasRsya hasRsya;

    @JsonUnwrapped
    private HasMobileMediation hasMobileMediation;

    @JsonUnwrapped
    private HasApproved hasApproved;

    @JsonUnwrapped
    private HasTutbyAgreement hasTutbyAgreement;

    @JsonUnwrapped
    private HasCommonOffer hasCommonOffer;

    public User() {
    }

    @SuppressWarnings("ParameterNumber")
    public User(
            Id id,
            Login login,
            Lastname lastname,
            Name name,
            Midname midname,
            Email email,
            Multistate multistate,
            ClientId clientId,
            Phone phone,
            Newsletter newsletter,
            BusinessUnit businessUnit,
            CreateDate createDate,
            IsMobileMediation isMobileMediation,
            HasRsya hasRsya,
            HasMobileMediation hasMobileMediation,
            HasApproved hasApproved,
            HasTutbyAgreement hasTutbyAgreement,
            HasCommonOffer hasCommonOffer
    ) {
        this.id = id;
        this.login = login;
        this.lastname = lastname;
        this.name = name;
        this.midname = midname;
        this.email = email;
        this.multistate = multistate;
        this.clientId = clientId;
        this.phone = phone;
        this.newsletter = newsletter;
        this.businessUnit = businessUnit;
        this.createDate = createDate;
        this.isMobileMediation = isMobileMediation;
        this.hasRsya = hasRsya;
        this.hasMobileMediation = hasMobileMediation;
        this.hasApproved = hasApproved;
        this.hasTutbyAgreement = hasTutbyAgreement;
        this.hasCommonOffer = hasCommonOffer;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User) o;
        return id.equals(user.id) &&
                login.equals(user.login) &&
                lastname.equals(user.lastname) &&
                name.equals(user.name) &&
                midname.equals(user.midname) &&
                email.equals(user.email) &&
                multistate.equals(user.multistate) &&
                clientId.equals(user.clientId) &&
                phone.equals(user.phone) &&
                newsletter.equals(user.newsletter) &&
                businessUnit.equals(user.businessUnit) &&
                createDate.equals(user.createDate) &&
                isMobileMediation.equals(user.isMobileMediation) &&
                hasRsya.equals(user.hasRsya) &&
                hasMobileMediation.equals(user.hasMobileMediation) &&
                hasApproved.equals(user.hasApproved) &&
                hasTutbyAgreement.equals(user.hasTutbyAgreement) &&
                hasCommonOffer.equals(user.hasCommonOffer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, login);
    }

    @Override
    public String toString() {
        return "User{" +
                "id=" + id.getValue() +
                ", login=" + login.getValue() +
                ", lastname=" + lastname.getValue() +
                ", name=" + name.getValue() +
                ", midname=" + midname.getValue() +
                ", email=" + email.getValue() +
                ", multistate=" + multistate.getValue() +
                ", clientId=" + clientId.getValue() +
                ", phone=" + phone.getValue() +
                ", newsletter=" + newsletter.getValue() +
                ", businessUnit=" + businessUnit.getValue() +
                ", createDate=" + createDate.getValue() +
                ", isMobileMediation=" + isMobileMediation.getValue() +
                ", hasRsya=" + hasRsya.getValue() +
                ", hasMobileMediation=" + hasMobileMediation.getValue() +
                ", hasApproved=" + hasApproved.getValue() +
                ", hasTutbyAgreement=" + hasTutbyAgreement.getValue() +
                ", hasCommonOffer=" + hasCommonOffer.getValue() +
                '}';
    }

    public void setId(Id id) {
        this.id = id;
    }

    public Id getId() {
        return id;
    }

    public Login getLogin() {
        return login;
    }

    public Lastname getLastname() {
        return lastname;
    }

    public Name getName() {
        return name;
    }

    public Midname getMidname() {
        return midname;
    }

    public Email getEmail() {
        return email;
    }

    public Multistate getMultistate() {
        return multistate;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public Phone getPhone() {
        return phone;
    }

    public Newsletter getNewsletter() {
        return newsletter;
    }

    public BusinessUnit getBusinessUnit() {
        return businessUnit;
    }

    public CreateDate getCreateDate() {
        return createDate;
    }

    public IsMobileMediation getIsMobileMediation() {
        return isMobileMediation;
    }

    public HasRsya getHasRsya() {
        return hasRsya;
    }

    public HasMobileMediation getHasMobileMediation() {
        return hasMobileMediation;
    }

    public HasApproved getHasApproved() {
        return hasApproved;
    }

    public HasTutbyAgreement getHasTutbyAgreement() {
        return hasTutbyAgreement;
    }

    public HasCommonOffer getHasCommonOffer() {
        return hasCommonOffer;
    }
}
