package ru.yandex.partner.coreexperiment.entity.user.repository;

import java.util.List;

import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.TableField;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.coreexperiment.AbstractRepository;
import ru.yandex.partner.coreexperiment.entity.field.Id;
import ru.yandex.partner.coreexperiment.entity.user.convertor.UserToUsersRecordConverter;
import ru.yandex.partner.coreexperiment.entity.user.convertor.UsersRecordToUserConverter;
import ru.yandex.partner.coreexperiment.entity.user.model.User;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;

import static ru.yandex.partner.dbschema.partner.tables.Users.USERS;

@Repository
public class UserRepository extends AbstractRepository<UsersRecord, User> {
    @SuppressWarnings("ModifierOrder")
    static private List<TableField<UsersRecord, ?>> tableFields = List.of(
            USERS.ID,
            USERS.LOGIN,
            USERS.LASTNAME,
            USERS.NAME,
            USERS.MIDNAME,
            USERS.EMAIL,
            USERS.MULTISTATE,
            USERS.CLIENT_ID,
            USERS.PHONE,
            USERS.NEWSLETTER,
            USERS.BUSINESS_UNIT,
            USERS.CREATE_DATE,
            USERS.IS_MOBILE_MEDIATION,
            USERS.OPTS
    );

    public UserRepository(
            DSLContext dsl,
            UsersRecordToUserConverter usersRecordToUserConverter,
            UserToUsersRecordConverter userToUsersRecordConverter
    ) {
        super(
                dsl,
                USERS,
                tableFields,
                usersRecordToUserConverter,
                userToUsersRecordConverter
        );
    }

    protected void setPk(User user, UsersRecord usersRecord) {
        Long id = usersRecord.getId();

        user.setId(new Id(id));
    }

    protected Condition getPkCondition(Object id) {
        return USERS.ID.eq((Long) id);
    }
}
