package ru.yandex.partner.core.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import one.util.streamex.StreamEx;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.action.exception.ActionError;

public class AbstractActionErrorHandler<T extends ModelWithId> implements ActionErrorHandler<T> {


    private final Map<Long, List<ActionError>> defects;

    protected AbstractActionErrorHandler() {
        this.defects = new HashMap<>();
    }

    @Override
    public boolean hasErrors() {
        return !defects.isEmpty();
    }

    @Override
    public boolean entityHasError(Long id) {
        var err = defects.getOrDefault(id, null);
        return err != null && !err.isEmpty();
    }

    @Override
    public void addErrorById(Long modelId, DefectInfo<Defect> defectInfo, ActionError.ActionDefectType defectType) {
        defects.computeIfAbsent(modelId, e -> new ArrayList<>()).add(new ActionError(defectInfo, defectType));
    }

    @Override
    public void addValidationErrors(ValidationResult<List<T>, Defect> vr) {
        var ids = vr.getValue().stream().map(ModelWithId::getId).collect(Collectors.toList());
        vr.getSubResults().entrySet()
                .stream().filter(it -> it.getValue().hasAnyErrors())
                .forEach(it -> {
                    var curId = ids.get(Integer.parseInt(it.getKey().toString()));
                    StreamEx.of(it.getValue().flattenErrors()).forEach(defectInfo ->
                            addErrorById(curId, defectInfo, ActionError.ActionDefectType.VALIDATION_DEFECT));
                });
    }

    @Override
    public void release() {
        defects.clear();
    }

    @Override
    public Map<Long, List<ActionError>> getDefects() {
        return defects;
    }
}
