package ru.yandex.partner.core.action;

import java.util.Collection;
import java.util.Set;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.action.factories.ActionConfigurationBuilder;

public interface ActionConfiguration<T extends ModelWithId, A extends TransitionAction<T, ?, ?>> {
    static <T extends ModelWithId, A extends TransitionAction<T, ?, ?>> ActionConfigurationBuilder<T, A> builder() {
        return new ActionConfigurationBuilder<>();
    }

    Set<ModelProperty<? extends Model, ?>> getDependsOnByClass(Class<T> clazz);

    Collection<ModelProperty<?, ?>> getDependsOn();

    Collection<ActionConfiguration<? extends ModelWithId, ?>> getAllowedNestedActions();
}
