package ru.yandex.partner.core.action;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.action.exception.ActionError;
import ru.yandex.partner.core.action.log.ActionsLogger;
import ru.yandex.partner.core.action.result.ActionsResult;
import ru.yandex.partner.core.entity.IncomingFields;

public interface ActionContext<T extends ModelWithId, C extends ActionModelContainer<T>> {
    void init();

    void commit(ActionsResult<?> result, IncomingFields updatedFields, boolean rollbackIfErrors);

    void preloadModels(Set<ModelProperty<? extends Model, ?>> preloadedProperties,
                       List<T> preloadedModels);

    List<C> getContainersWithoutErrors(Collection<Long> ids);

    Set<Long> entityIdsWithErrors();

    boolean hasErrors();

    Map<Long, List<ActionError>> getErrors();

    Class<T> getEntityClass();

    ActionsLogger actionLogger();
}
