package ru.yandex.partner.core.action;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.operation.Operation;
import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.filter.CoreFilterNode;

public interface ActionContextWithModelProperty<
        T extends ModelWithId,
        C extends ActionModelContainerWithModelProperty<T>
        > extends ActionContext<T, C> {
    List<ModelChanges<T>> getModelChangesToUpdate();

    Operation<Long> getUpdateOperation(List<ModelChanges<T>> modelChanges,
                                       IncomingFields updatedFields,
                                       boolean rollbackIfErrors);

    List<C> getContainers(Collection<Long> ids,
                          Set<ModelProperty<? extends Model, ?>> fields,
                          Boolean withoutErrors);

    List<C> getContainers(
            Collection<Long> ids, Set<ModelProperty<?, ?>> fields, Boolean withoutErrors, CoreFilterNode<T> filter
    );

    void addFieldsToRequired(Collection<ModelProperty<?, ?>> fields);
}
