package ru.yandex.partner.core.action;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.action.exception.ActionError;

public interface ActionErrorHandler<T extends ModelWithId> {

    boolean hasErrors();

    boolean entityHasError(Long id);

    void addErrorById(Long modelId, DefectInfo<Defect> defect, ActionError.ActionDefectType defectType);

    void addValidationErrors(ValidationResult<List<T>, Defect> vr);

    void release();

    Map<Long, List<ActionError>> getDefects();
}
