package ru.yandex.partner.core.action;

import java.util.Set;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;

public interface ActionModelContainerWithModelProperty<
        T extends ModelWithId
        > extends ActionModelContainer<T> {
    Set<ModelProperty<? super T, ?>> getNonExistingFields(Set<ModelProperty<? extends Model, ?>> checkFields);

    Set<ModelProperty<? super T, ?>> getChangedFields();

    <V> void changeProperty(ModelProperty<? super T, V> modelProperty, V value);

    <V> V getProperty(ModelProperty<? super T, V> modelProperty);

    void resetChangedFields();
}
