package ru.yandex.partner.core.action;

import java.util.List;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.action.result.ActionsResult;


public interface ActionPerformer {
    <T extends ModelWithId, C extends ActionModelContainer<T>, R>
    ActionsResult<R> doActions(TransitionAction<T, C, R> action);

    <T extends ModelWithId, C extends ActionModelContainer<T>, R>
    ActionsResult<R> doActions(boolean rollbackIfErrors, TransitionAction<T, C, R> action);

    <T extends ModelWithId, C extends ActionModelContainer<T>> ActionsResult<?> doActions(
            TransitionAction<T, C, ?>... actions);

    <T extends ModelWithId, C extends ActionModelContainer<T>> ActionsResult<?> doActions(
            boolean rollbackIfErrors, TransitionAction<T, C, ?>... actions);

    <T extends ModelWithId, C extends ActionModelContainer<T>> ActionsResult<?> doActions(
            boolean rollbackIfErrors, List<TransitionAction<T, C, ?>> actions);

    ActionContextFacade getActionContextFacade();
}
