package ru.yandex.partner.core.action;

import java.util.function.Supplier;

import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.configuration.annotation.ThreadScope;

import static ru.yandex.partner.core.CoreConstants.SYSTEM_CRON_USER_ID;

@Component
@ThreadScope
public class ActionUserIdContext implements Supplier<Long> {

    private Long userId;

    public ActionUserIdContext() {
        setDefault();
    }

    public void setUserId(@NotNull Long userId) {
        this.userId = userId;
    }

    @Override
    public @NotNull Long get() {
        return userId;
    }

    public void setDefault() {
        this.userId = SYSTEM_CRON_USER_ID;
    }
}
