package ru.yandex.partner.core.action;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

public class ActionUtils {

    private ActionUtils() {
    }

    public static <B extends BlockWithMultistate> List<Long> filteredItemIdsByMultistateFlag(
            List<ActionModelContainerImpl<B>> containers,
            BlockStateFlag stateFlag) {
        return containers.stream()
                .map(ActionModelContainerImpl::getItem)
                .filter(block -> block.getMultistate().test(stateFlag))
                .map(B::getId)
                .collect(Collectors.toList());
    }
}
