package ru.yandex.partner.core.action;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

import one.util.streamex.StreamEx;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;

public class DefaultActionConfiguration<T extends ModelWithId, A extends TransitionAction<T, ?, ?>>
        implements ActionConfiguration<T, A> {
    private final Collection<ModelProperty<? extends Model, ?>> requiredProps;
    private final Collection<ActionConfiguration<?, ?>> allowedNestedActions;

    public DefaultActionConfiguration(Collection<ModelProperty<T, ?>> requiredProps,
                                      Collection<ModelProperty<?, ?>> dependProps,
                                      Collection<ActionConfiguration<?, ?>> allowedNestedActions) {
        this.requiredProps = StreamEx.of(dependProps).append(requiredProps).toSet();
        this.allowedNestedActions = allowedNestedActions;
    }

    @Override
    public Set<ModelProperty<? extends Model, ?>> getDependsOnByClass(Class<T> clazz) {
        var entityInterfaces = StreamEx.of(clazz.getInterfaces()).toCollection(HashSet::new);
        entityInterfaces.add(clazz);
        return StreamEx.of(requiredProps).filter(it ->
                entityInterfaces.contains(it.getModelClass())).collect(Collectors.toSet());
    }

    @Override
    public Collection<ModelProperty<?, ?>> getDependsOn() {
        return requiredProps;
    }

    @Override
    public Collection<ActionConfiguration<?, ?>> getAllowedNestedActions() {
        return allowedNestedActions;
    }

    @Override
    public String toString() {
        return "DefaultActionConfiguration{" +
                "requiredProps=" + requiredProps +
                ", allowedNestedActions=" + allowedNestedActions +
                '}';
    }
}
