package ru.yandex.partner.core.action;

import java.util.List;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.action.log.ActionsLogger;

public interface TransitionAction<T extends ModelWithId, C extends ActionModelContainer<T>, R>
        extends OnActionHook<T, C, ActionContext<T, C>, R> {
    List<Long> getContainerIds();

    void check(List<C> containers);

    void changeMultistate(List<C> containers);

    String getName();

    String getSerializedOpts(Long id);

    Class<T> getEntityClass();

    void makeLogging(ActionsLogger actionsLogger, C container);

    void prepareContext(ActionContextWithModelProperty<T, ?> actionContext);

    ActionConfiguration<T, ?> getConfiguration();
}
