package ru.yandex.partner.core.action.exception;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.multistate.Multistate;

@ParametersAreNonnullByDefault
public class ActionDefectParams {
    private Class<?> entityClass;
    private String actionName;
    private Long modelId;
    private Multistate<?> multistate;
    private Long userId;

    public Class<?> getEntityClass() {
        return entityClass;
    }

    public String getActionName() {
        return actionName;
    }

    public ActionDefectParams withActionName(String actionName) {
        this.actionName = actionName;
        return this;
    }

    public ActionDefectParams withEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    public ActionDefectParams withMultistate(Multistate<?> multistate) {
        this.multistate = multistate;
        return this;
    }

    public ActionDefectParams withUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public ActionDefectParams withModelId(Long modelId) {
        this.modelId = modelId;
        return this;
    }

    @Override
    public String toString() {
        return "ActionDefectParams{" +
                "entityClass=" + entityClass +
                ", actionName='" + actionName + '\'' +
                ", modelId=" + modelId +
                ", multistate=" + multistate +
                ", userId=" + userId +
                '}';
    }
}
