package ru.yandex.partner.core.action.exception;


import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;

public class ActionError {
    private final DefectInfo<Defect> defectInfo;
    private final ActionDefectType defectType;

    public ActionError(DefectInfo<Defect> defectInfo, ActionDefectType defectType) {
        this.defectInfo = defectInfo;
        this.defectType = defectType;
    }

    public DefectInfo<Defect> getDefectInfo() {
        return defectInfo;
    }

    public ActionDefectType getDefectType() {
        return defectType;
    }

    @Override
    public String toString() {
        return "ActionError{" +
                "defectInfo=" + defectInfo +
                ", defectType=" + defectType +
                '}';
    }


    public enum ActionDefectType {
        VALIDATION_DEFECT, CAN_NOT_DO_ACTION, OTHER
    }

}
