package ru.yandex.partner.core.action.exception;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;
import ru.yandex.partner.libs.i18n.GettextMsg;

public enum DefectInfoWithMsgId implements DefectId<DefectInfoWithMsgParams> {
    ID;

    public static <T> Defect<T> defect(GettextMsg msg) {
        return (Defect<T>) new Defect(DefectInfoWithMsgId.ID,
                new DefectInfoWithMsgParams(msg));
    }

    public static <T> Defect<T> defect(GettextMsg msg, Object... args) {
        return (Defect<T>) new Defect(DefectInfoWithMsgId.ID,
                new DefectInfoWithMsgParams(msg.format(args)));
    }
}
