package ru.yandex.partner.core.action.exception.presentation;

import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum ActionDefectMsg implements GettextMsg {

    CAN_NOT_DO_ACTION(msg("Cannot do action \"%s\"."), "lib__QBit__Application__Model__Multistate__DB.pm"),
    INCORRECT_REQUEST_BODY(msg("Incorrect request body"), "lib__RestApi__Controller.pm");


    private final GettextMsgPayload payload;
    private final String keyset;

    ActionDefectMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    ActionDefectMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @NotNull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @NotNull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
