package ru.yandex.partner.core.action.factories;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.DefaultActionConfiguration;
import ru.yandex.partner.core.action.TransitionAction;

public class ActionConfigurationBuilder<T extends ModelWithId, A extends TransitionAction<T, ?, ?>> {

    private final Set<ActionConfiguration<?, ?>> allowedNestedActions = new HashSet<>();
    private final Set<ModelProperty<T, ?>> requiredProps = new HashSet<>();

    public ActionConfigurationBuilder<T, A> dependsOn(ModelProperty<?, ?> prop) {
        this.requiredProps.add((ModelProperty<T, ?>) prop);
        return this;
    }

    public ActionConfigurationBuilder<T, A> allowNested(ActionConfiguration<? super ModelWithId, ?> nestedAction) {
        this.allowedNestedActions.add(nestedAction);
        return this;
    }

    ActionConfigurationBuilder<T, A> allowNestedInternal(ActionConfiguration<?, ?> nestedAction) {
        this.allowedNestedActions.add(nestedAction);
        return this;
    }

    public ActionConfiguration<T, A> build() {
        return new DefaultActionConfiguration<>(
                requiredProps,
                getDependsFields(allowedNestedActions),
                allowedNestedActions
        );
    }

    private Set<ModelProperty<?, ?>> getDependsFields(Collection<ActionConfiguration<?, ?>> configs) {
        Set<ModelProperty<?, ?>> result = new HashSet<>();
        for (ActionConfiguration<?, ?> childConf: configs) {
            result.addAll(childConf.getDependsOn());
            result.addAll(getDependsFields(childConf.getAllowedNestedActions()));
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActionConfigurationBuilder<?, ?> that = (ActionConfigurationBuilder<?, ?>) o;
        return Objects.equals(allowedNestedActions, that.allowedNestedActions) && Objects.equals(requiredProps,
                that.requiredProps);
    }

    @Override
    public int hashCode() {
        return Objects.hash(allowedNestedActions, requiredProps);
    }
}
