package ru.yandex.partner.core.action.factories;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.TransitionAction;

/**
 * Интерфейс фабрики экшена с общей конфигурацией.
 * <p>
 * Кроме конфигурации, работает как интерфейс-маркер и не вводит общие сигнатуры создания,
 * т.к. конкретные методы создания экшенов могут иметь различные параметры.
 */
public interface ActionConfigurationFactory<T extends ModelWithId, A extends TransitionAction<T, ?, ?>> {
    /**
     * Конфигурация экшена.
     * Все конфигурации должны либо быть синглтонами,
     * либо корректно реализовывать equals/hashCode для проверки допустимости использования
     * как nestedAction.
     */
    ActionConfiguration<T, A> getActionConfiguration();
}
