package ru.yandex.partner.core.action.factories;

import java.util.List;
import java.util.Map;
import java.util.function.Function;

import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.action.TransitionAction;

@Component
public class AllCustomPayloadActionsFactory {

    private final Map<Pair<String, Class<? extends ModelWithId>>,
            CustomPayloadActionFactory<? extends ModelWithId, ? extends TransitionAction<?, ?, ?>>> factories;

    @Autowired
    public AllCustomPayloadActionsFactory(List<CustomPayloadActionFactory<?
            extends ModelWithId, ? extends TransitionAction<?, ?, ?>>> factories) {
        this.factories = StreamEx.of(factories).toMap(it -> Pair.of(it.getName(), it.getModelClass()),
                Function.identity());
    }

    public CustomPayloadActionFactory<? extends ModelWithId, ? extends TransitionAction<?, ?, ?>> getFactory(
            String actionName, Class<? extends ModelWithId> modelClass) {
        return factories.get(Pair.of(actionName, modelClass));
    }

}
