package ru.yandex.partner.core.action.factories;

import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.action.ActionModelContainer;
import ru.yandex.partner.core.action.ActionPayloadType;
import ru.yandex.partner.core.action.TransitionAction;
import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.libs.multistate.action.ActionNameHolder;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

public abstract class CustomPayloadActionFactory<
        T extends ModelWithId,
        A extends TransitionAction<T, ? extends ActionModelContainer<T>, ?>> extends ActionFactory<T, A> {

    public CustomPayloadActionFactory(ActionNameHolder action,
                                      MultistateGraph<T, ? extends StateFlag> multistateGraph) {
        super(new SmartActionConfigurationFactory<>(action, multistateGraph));
    }

    public CustomPayloadActionFactory(ActionConfigurationFactory<T, A> actionConfigurationFactory) {
        super(actionConfigurationFactory);
    }

    @Override
    public final ActionPayloadType getType() {
        return ActionPayloadType.CUSTOM;
    }

    public A createAction(Long id, JsonNode payload) {
        return createAction(List.of(id), payload);
    }

    public abstract A createAction(List<Long> ids, JsonNode payload);
}
