package ru.yandex.partner.core.action.factories;

import java.util.Collection;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.action.ActionModelContainer;
import ru.yandex.partner.core.action.ActionPayloadType;
import ru.yandex.partner.core.action.TransitionAction;
import ru.yandex.partner.core.entity.IncomingFields;

public abstract class ModelPayloadActionFactory<
        T extends ModelWithId, A extends TransitionAction<T, ? extends ActionModelContainer<T>, ?>>
        extends ActionFactory<T, A> {

    public ModelPayloadActionFactory(ActionConfigurationFactory<T, A> actionConfigurationFactory) {
        super(actionConfigurationFactory);
    }

    @Override
    public final ActionPayloadType getType() {
        return ActionPayloadType.MODEL;
    }

    public abstract A createAction(Collection<ModelChanges<? super T>> modelChanges,
                                   IncomingFields updatedFields);

    public A createAction(Collection<ModelChanges<? super T>> modelChanges) {
        return createAction(modelChanges, new IncomingFields());
    }
}
