package ru.yandex.partner.core.action.factories;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.TransitionAction;
import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.libs.multistate.action.ActionNameHolder;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

/**
 * Must be bean
 * see {@link ActionFactory#init()}
 */
public class SmartActionConfigurationFactory<T extends ModelWithId, A extends TransitionAction<T, ?, ?>>
        implements ActionConfigurationFactory<T, A>, SmartActionConfigurationLifecycle<T, A> {
    private ActionConfigurationBuilder<T, A> builder;
    private ActionConfiguration<T, A> completeConfiguration;

    private SmartActionConfigurationFactory() {
        this(new ActionConfigurationBuilder<>());
    }

    public SmartActionConfigurationFactory(
            ActionNameHolder action,
            MultistateGraph<T, ? extends StateFlag> multistateGraph
    ) {
        this();

        multistateGraph.getRequiredPropertiesByActionName(action.getActionName()).forEach(builder::dependsOn);
    }

    @SafeVarargs
    public SmartActionConfigurationFactory(
            ActionNameHolder action,
            MultistateGraph<T, ? extends StateFlag> multistateGraph,
            ModelProperty<? super T, ?>... props) {
        this(action, multistateGraph, Arrays.asList(props));
    }

    public SmartActionConfigurationFactory(
            ActionNameHolder action,
            MultistateGraph<T, ? extends StateFlag> multistateGraph,
            Collection<ModelProperty<? super T, ?>> props) {
        this();

        multistateGraph.getRequiredPropertiesByActionName(action.getActionName()).forEach(builder::dependsOn);

        props.forEach(this.builder::dependsOn);
    }

    private SmartActionConfigurationFactory(ActionConfigurationBuilder<T, A> builder) {
        this.builder = builder;
    }

    public SmartActionConfigurationFactory(Collection<ModelProperty<? super T, ?>> props) {
        this();
        props.forEach(this.builder::dependsOn);
    }


    @Override
    public ActionConfiguration<T, A> getActionConfiguration() {
        return Objects.requireNonNull(completeConfiguration,
                "Конфигурация фабрики экшенов ещё не завершена! " +
                        "Проверьте зависимости между фабриками на наличие циклов.");
    }

    // package private for post processor access
    @Override
    public ActionConfigurationBuilder<T, A> getBuilder() {
        return Objects.requireNonNull(builder,
                "Конфигурация фабрики экшенов завершена, дальнейшая настройка невозможна!");
    }

    @Override
    public ActionConfiguration<T, A> complete() {
        this.completeConfiguration = getBuilder().build();
        this.builder = null;
        return this.completeConfiguration;
    }
}
