package ru.yandex.partner.core.action.helper;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.utils.converter.ModelPropertyNameConverter;

public class ActionOptsHelper {
    private static final Logger logger = LoggerFactory.getLogger(ActionOptsHelper.class);

    private ActionOptsHelper() {
        //helper
    }

    public static <M extends ModelWithId> String prepareSerializedOptsForUpdated(ModelChanges<M> modelChanges,
                                                                                 ObjectMapper objectMapper,
                                                                                 Class<M> mClass) {
        if (Objects.isNull(modelChanges)) {
            return "";
        }
        var mapping = ModelPropertyNameConverter.convert(modelChanges.getChangedPropsNames(), mClass);
        var resultMap = Maps.newHashMapWithExpectedSize(modelChanges.getChangedPropsNames().size());
        modelChanges.getChangedPropsNames().forEach(it ->
                resultMap.put(mapping.get(it), modelChanges.getChangedProp(it))
        );

        try {
            return objectMapper.writeValueAsString(resultMap);
        } catch (JsonProcessingException e) {
            logger.error(e.getMessage());
            return "";
        }
    }

    public static <M extends ModelWithId> String getSerializedOptsForAdd(
            Long id, ObjectMapper objectMapper,
            String actionName,
            Class<M> mClass, M addedModel,
            Set<ModelProperty<? super M, ?>> changedProps) {
        if (changedProps == null || addedModel == null) {
            logger.warn("No changes for {} {}, but action serialization was invoked!", actionName, id);
            return "{}";
        }

        Map<ModelProperty<? super M, ?>, String> propNames =
                ModelPropertyNameConverter.convert(changedProps, mClass);
        var resultMap = Maps.<String, Object>newHashMapWithExpectedSize(changedProps.size());

        for (ModelProperty<? super M, ?> changedProp : changedProps) {
            resultMap.put(
                    propNames.get(changedProp),
                    changedProp.get(addedModel)
            );
        }

        try {
            return objectMapper.writeValueAsString(resultMap);
        } catch (JsonProcessingException e) {
            logger.error("Could not serialize action {} {}", actionName, id, e);
            return "{}";
        }
    }


}
