package ru.yandex.partner.core.action.log;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;

import ru.yandex.partner.core.action.ActionUserIdContext;

public class SimpleDbActionLogger<R extends Record> extends AbstractActionsLogger<R> {

    private final UnifiedRecordBuilder<R> recordBuilder;

    public SimpleDbActionLogger(DSLContext dslContext, Table<R> table, UnifiedRecordBuilder<R> recordBuilder,
                                ActionUserIdContext actionUserIdContext) {
        super(dslContext, table, actionUserIdContext);
        this.recordBuilder = recordBuilder;
    }

    @Override
    protected R getRecord(Long userId, Long modelId, long oldMultistate, String actionName, long newMultistate,
                          String opts) {
        return recordBuilder.buildRecord(userId, modelId, oldMultistate, actionName, newMultistate, opts);
    }
}
