package ru.yandex.partner.core.bs

import com.google.common.annotations.VisibleForTesting
import com.google.protobuf.Message
import ru.yandex.direct.model.Model

class BkDataFacade<M : Model, MSG : Message, B : Message.Builder, C>(
    private val messageBuilderProvider: () -> B,
    messageFillers: List<BkFiller<out M, in B, C>>
) {

    @VisibleForTesting
    val orderedMessageFillers = PartialOrdering(
        Comparator.comparing<BkFiller<*, *, C>, Class<*>>({ it.typeClass }, InheritanceOrder())
    ).sort(messageFillers)

    fun generateBkData(models: List<M>, container: C): List<MSG> {
        for (messageFiller in orderedMessageFillers) {
            (messageFiller as BkFiller<M, B, C>).fillContainer(
                container,
                models.filter(messageFiller.typeClass::isInstance)
            )
        }

        return models.map { model ->
            val builder = messageBuilderProvider()
            for (messageFiller in orderedMessageFillers) {
                if (!messageFiller.typeClass.isInstance(model)) {
                    continue
                }
                (messageFiller as BkFiller<M, B, C>).fillBkData(
                    model,
                    builder,
                    container
                )
            }
            builder.build() as MSG
        }
    }

    val supportedTypes = messageFillers.map { it.typeClass }.toSet()
}
