package ru.yandex.partner.core.bs

import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.stereotype.Component
import ru.yandex.partner.core.block.BlockType

@ConfigurationProperties("bs.enrich")
@Component
class BkEnrichConfig {
    lateinit var supportedBlockTypes: Set<BlockType>
    val supportedBlockTypesLiteral: Set<String> by lazy {
        supportedBlockTypes.map { it.literal }.toSet()
    }

    lateinit var rtbVideoSupportedBlockTypes: Set<BlockType>
    val rtbVideoSupportedBlockTypesLiteral: Set<String> by lazy {
        rtbVideoSupportedBlockTypes.map { it.literal }.toSet()
    }
}
