package ru.yandex.partner.core.bs

import com.google.protobuf.Message
import ru.yandex.direct.model.Model
import ru.yandex.direct.multitype.typesupport.TypeSupport

/**
 * 1. Имплементациии реализуют функционал переноса данных из модели в сообщение PB
 * 2. Интерфейс является маркерным, по нему отбираются тайп-саппорты
 * для вычитки данных перед отправкой в БК
 */
interface BkFiller<M : Model, BK : Message.Builder, C> : TypeSupport<M> {
    fun fillBkData(model: M, bkData: BK, container: C)

    fun fillContainer(container: C, models: List<M>)

    fun order(): Int = Integer.MAX_VALUE
}
