package ru.yandex.partner.core.bs

/**
 * Отношение частичного порядка, где классы-наследники обрабатываются позже, чем базовые классы
 * Подходит не для всех типов сортировок
 */
class InheritanceOrder : Comparator<Class<*>> {
    override fun compare(a: Class<*>, b: Class<*>): Int {
        if (a == b) {
            return 0
        }

        return when {
            a.isAssignableFrom(b) -> -1
            b.isAssignableFrom(a) -> 1
            // we are good with partial order here
            else -> 0
        }
    }
}
