package ru.yandex.partner.core.bs

class PartialOrdering<T>(
    private val cmp: Comparator<T>
) {
    fun sort(list: List<T>): List<T> {
        val newList = ArrayList<T>(list.size)
        if (list.isEmpty()) {
            return newList
        }
        list.forEach { item ->
            val ind = newList.indexOfFirst { cmp.compare(item, it) < 0 }
            newList.add(if (ind == -1) newList.size else ind, item)
        }
        return newList
    }
}
