package ru.yandex.partner.core.bs.enrich;

import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum RtbVideoMsg implements GettextMsg {
    DOMAIN_OF_VIDEO_RESOURCE(msg("Domain of video resourse")),
    VIDEO_RESOURCES(msg("Video resources"), "lib__MenuHierarchy.pm");

    private static final String KEYSET_NAME = "lib__Application__Model__Role__Has__ShowVideo.pm";
    private final GettextMsgPayload payload;
    private final String keyset;

    RtbVideoMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder.build();
        this.keyset = keyset;
    }

    RtbVideoMsg(GettextMsgPayload.Builder builder) {
        this(builder, KEYSET_NAME);
    }

    @NotNull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @NotNull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
