package ru.yandex.partner.core.bs.transport;

import java.util.List;

import com.google.protobuf.ByteString;

import ru.yandex.partner.unifiedagent.LogbrokerDto;

public class ProtobufLogbrokerDto implements LogbrokerDto {

    private final List<ByteString> messages;
    private final String topic;

    public ProtobufLogbrokerDto(List<ByteString> messages, String topic) {
        this.messages = messages;
        this.topic = topic;
    }

    @Override
    public List<ByteString> getMessages() {
        return messages;
    }

    @Override
    public String getTopic() {
        return topic;
    }

    @Override
    public String toString() {
        return "ProtobufLogbrokerDto{" +
                "messages=" + messages +
                ", topic='" + topic + '\'' +
                '}';
    }
}
