package ru.yandex.partner.core.configuration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import ru.yandex.inside.passport.blackbox2.BlackboxRawRequestExecutor;
import ru.yandex.inside.passport.blackbox2.BlackboxRequestExecutor;
import ru.yandex.inside.passport.blackbox2.BlackboxRequestExecutorWithRetries;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.partner.libs.extservice.blackbox.BlackBoxRtcConfig;
import ru.yandex.passport.tvmauth.NativeTvmClient;
import ru.yandex.passport.tvmauth.TvmClient;
import ru.yandex.passport.tvmauth.TvmToolSettings;

@Configuration
@ComponentScan(basePackages = {
        "ru.yandex.partner.libs.extservice.blackbox"
})
public class BlackBoxAndTvmConfiguration {

    @Bean
    public BlackboxRequestExecutor blackboxRequestExecutor(BlackBoxRtcConfig blackBoxRtcConfig) {
        HttpClient httpClient = ApacheHttpClientUtils.multiThreadedClient(
                Timeout.milliseconds(blackBoxRtcConfig.getTimeout().toMillis()),
                blackBoxRtcConfig.getMaxConnections()
        );
        var blackboxRawRequestExecutor = new BlackboxRawRequestExecutor(
                Objects.requireNonNull(blackBoxRtcConfig.getUrl(), "Blackbox url can't be null"),
                httpClient
        );
        return new BlackboxRequestExecutorWithRetries(
                blackboxRawRequestExecutor,
                blackBoxRtcConfig.getRetries()
        );
    }

    @Bean
    public TvmClient tvmClient(@Value("${tvm.url:http://localhost:18080}") String url,
                               @Value("${tvm.token}") String token,
                               @Value("${tvm.selfSrcAlias}") String selfSrcAlias
    ) throws MalformedURLException {
        URL urlObj = new URL(url);
        TvmToolSettings tvmToolSettings = new TvmToolSettings(selfSrcAlias);
        tvmToolSettings.setAuthToken(token);
        tvmToolSettings.setHostname(urlObj.getHost());
        tvmToolSettings.setPort(urlObj.getPort());
        return new NativeTvmClient(tvmToolSettings);
    }
}

