package ru.yandex.partner.core.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.partner.core.validation.defects.presentation.ModelPropertyPresentationNameService;
import ru.yandex.partner.core.validation.defects.presentation.SimpleModelPropertyPresentationNameService;
import ru.yandex.partner.defaultconfiguration.DefaultPartnerConfiguration;
import ru.yandex.partner.libs.i18n.TranslatableError;
import ru.yandex.partner.libs.rbac.configuration.RbacConfiguration;
import ru.yandex.partner.unifiedagent.UnifiedAgentConfig;

import static ru.yandex.direct.validation.presentation.DefectPresentationRegistryFactory.strictRegistry;
import static ru.yandex.partner.core.entity.block.service.validation.defects.presentation.BlockDefectPresentationRegistry.blockDefectPresentationRegistry;
import static ru.yandex.partner.core.entity.page.service.validation.defects.presentation.PageDefectPresentationRegistry.pageDefectPresentationRegistry;
import static ru.yandex.partner.core.entity.simplemodels.kvstorefrontend.service.validation.presentation.KvStoreFrontendDefectPresentationRegistry.kvStoreDefectPresentationRegistry;
import static ru.yandex.partner.core.entity.user.service.validation.defects.presentation.UserDefectPresentationRegistry.userDefectPresentationRegistry;
import static ru.yandex.partner.core.validation.defects.presentation.CommonDefectPresentations.commonDefectPresentationRegistry;

@Configuration
@EnableCaching
@ComponentScan(basePackages = {"ru.yandex.partner.core", "ru.yandex.partner.libs.extservice.banner"})
@Import({
        DefaultPartnerConfiguration.class,
        RbacConfiguration.class,
        CustomScopesConfiguration.class,
        UnifiedAgentConfig.class
})
public class CoreConfiguration {

    @Bean
    public DefectPresentationRegistry<TranslatableError> defectPresentationService(
            @Autowired(required = false) ModelPropertyPresentationNameService modelPropertyPresentationNameService) {
        var service = modelPropertyPresentationNameService == null
                ? new SimpleModelPropertyPresentationNameService()
                : modelPropertyPresentationNameService;
        DefaultDefectPresentationRegistry<TranslatableError> generalRegistry =
                DefaultDefectPresentationRegistry.builder()
                        .register(commonDefectPresentationRegistry(service))
                        .register(userDefectPresentationRegistry())
                        .register(blockDefectPresentationRegistry())
                        .register(kvStoreDefectPresentationRegistry())
                        .register(pageDefectPresentationRegistry())
                        .build();

        return strictRegistry(generalRegistry);
    }
}
