package ru.yandex.partner.core.configuration;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.CustomScopeConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.SimpleThreadScope;
import org.springframework.transaction.support.SimpleTransactionScope;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Configuration
public class CustomScopesConfiguration {

    @Bean
    public CustomScopeConfigurer customScopeConfigurer() {
        var scopeConfigurer = new CustomScopeConfigurer();
        scopeConfigurer.addScope("thread", new SimpleThreadScope());
        scopeConfigurer.addScope(
                "transaction-with-fallback",
                new SimpleTransactionScope() {
                    @Override
                    public Object get(String name, ObjectFactory<?> objectFactory) {
                        if (TransactionSynchronizationManager.isActualTransactionActive()) {
                            return super.get(name, objectFactory);
                        } else {
                            return objectFactory.getObject();
                        }
                    }
                });
        return scopeConfigurer;
    }
}
