package ru.yandex.partner.core.configuration.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

/**
 * Бины помеченные этим скоупом живут в пределах одного потока
 * <p>
 * Можно внедрять так же как Singleton бины, работает через прокси методы спринга
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Scope(value = "thread", proxyMode = ScopedProxyMode.TARGET_CLASS)
public @interface ThreadScope {
}
