package ru.yandex.partner.core.entity;

import java.util.List;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.entity.LimitOffset;
import ru.yandex.partner.core.utils.OrderBy;

public interface DefaultQuery<M extends ModelWithId> extends Query<M> {

    DefaultQuery<M> withLimitOffset(LimitOffset limitOffset);

    DefaultQuery<M> withLimit(int limit);

    DefaultQuery<M> withOrder(@NotNull OrderBy... order);

    DefaultQuery<M> withOrder(@Nullable List<OrderBy> orderByList);
}
