package ru.yandex.partner.core.entity;

import java.util.Set;

import javax.annotation.Nonnull;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.SelectConditionStep;
import org.jooq.Table;
import org.jooq.TableField;

/**
 * Абстрактный класс для репозитория сущностей, которые нужно сверять со справочником
 * (заготовка, заточенная на валидацию по id. Подлежит к расширению для получения самих сущностей)
 */
public abstract class DictRepository<R extends Record> {

    public Set<Long> getExistingIds(DSLContext dslContext, Set<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return Set.of();
        }

        return getIds(dslContext, ids);
    }

    public Set<Long> getAllExistingIds(DSLContext dslContext) {
        return getIds(dslContext, null);
    }

    private Set<Long> getIds(DSLContext dslContext, Set<Long> ids) {
        TableField<R, Long> idField = getIdField();

        SelectConditionStep<Record1<Long>> conditionStep = dslContext.select(idField)
                .from(getTable())
                .where(idField.notEqual(0L));

        if (ids != null) {
            conditionStep = conditionStep.and(idField.in(ids));
        }

        return conditionStep.fetchSet(idField);
    }

    @Nonnull
    protected abstract Table<R> getTable();

    @Nonnull
    protected abstract TableField<R, Long> getIdField();
}
