package ru.yandex.partner.core.entity;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;

import javax.annotation.Nullable;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class IncomingFields {

    private final Multimap<Model, ModelProperty<?, ?>> updatedPropertiesPerModel;
    private final Set<String> updatedFields;

    public IncomingFields() {
        this(Multimaps.newSetMultimap(new IdentityHashMap<>(), HashSet::new));
    }

    public IncomingFields(Multimap<Model, ModelProperty<?, ?>> updatedPropertiesPerModel) {
        this.updatedPropertiesPerModel = updatedPropertiesPerModel;
        this.updatedFields = new HashSet<>();
    }

    public void addIncomingFields(Multimap<Model, ModelProperty<?, ?>> parseJsonMap) {
        updatedPropertiesPerModel.putAll(parseJsonMap);
    }

    @Nullable
    public Collection<ModelProperty<?, ?>> getUpdatedFields(Model entity) {
        return updatedPropertiesPerModel.asMap().get(entity);
    }

    public Multimap<Model, ModelProperty<?, ?>> getUpdatedPropertiesPerModel() {
        return updatedPropertiesPerModel;
    }

    public Set<ModelProperty<?, ?>> getAllModelProperties() {
        return new HashSet<>(updatedPropertiesPerModel.values());
    }

    public void merge(IncomingFields other) {
        this.updatedPropertiesPerModel.putAll(other.updatedPropertiesPerModel);
        this.updatedFields.addAll(other.updatedFields);
    }

    public void putUpdatedField(String jsonName) {
        updatedFields.add(jsonName);
    }

    public Set<String> getUpdatedFields() {
        return updatedFields;
    }

    public void addUpdatedFields(Set<String> updatedFieldsSet) {
        updatedFields.addAll(updatedFieldsSet);
    }
}
