package ru.yandex.partner.core.entity;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.entity.tasks.doaction.DoActionFilterEnum;
import ru.yandex.partner.core.filter.meta.MetaFilter;

public interface ModelQueryService<M extends ModelWithId> {

    <S extends M> List<S> findAll(Query<S> opts);

    default List<Long> getIds(Query<? super M> opts) {
        ModelProperty<Model, Long> id = (ModelProperty<Model, Long>) this.getIdModelProperty();

        return findAll((QueryOpts<? extends M>) opts.withProps(Set.of(id))).stream()
                .map(id::get)
                .collect(Collectors.toList());
    }

    <S extends M> long count(Query<S> opts);

    ModelProperty<? extends Model, Long> getIdModelProperty();

    Class<M> getBaseClass();

    <S extends M> MetaFilter<? super S, ?> getMetaFilterForDoAction(DoActionFilterEnum doActionFilterEnum);
}
