package ru.yandex.partner.core.entity;

import java.util.Objects;

public class PageBlockIds {
    private final long pageId;
    private final long blockId;

    public PageBlockIds(long pageId, long blockId) {
        this.pageId = pageId;
        this.blockId = blockId;
    }

    public long getPageId() {
        return pageId;
    }

    public long getBlockId() {
        return blockId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageBlockIds)) {
            return false;
        }
        PageBlockIds that = (PageBlockIds) o;
        return pageId == that.pageId &&
                blockId == that.blockId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(pageId, blockId);
    }
}
